/*
 * Decompiled with CFR 0.152.
 */
package com.florianhaber.camlog.ast;

import com.florianhaber.camlog.ast.AST;
import com.florianhaber.camlog.ast.PAT;
import com.florianhaber.camlog.ast.TYP;
import com.florianhaber.camlog.cam.CCC;
import com.florianhaber.camlog.utl.UTL;
import java.util.Map;

public class ALG {
    public static Structure One = new Application(TYP.Constructor.One);

    static class Constructor
    extends AST.Atomic {
        public Functor func;
        public CCC.Combinator strip;
        public CCC.Combinator guard;

        public Constructor(String string, Functor functor, TYP.Scheme scheme) {
            super(new CCC.Abstract(new CCC.Compose(CCC.Snd, functor.comb), string), scheme);
            PAT.Variable variable = new PAT.Variable("$X");
            this.strip = new CCC.Abstract(new CCC.Compose(CCC.Snd, functor.patapp(variable).compileOcc(variable)), "=" + string);
            this.guard = new CCC.Abstract(new CCC.Compose(CCC.Snd, functor.patapp(new PAT.GenericVariable()).guard()), "=" + string + "?");
            this.func = functor;
        }

        public String toString() {
            return this.func.toString();
        }
    }

    private static abstract class Functor {
        public CCC.Combinator comb;
        static Functor Id = new Functor(CCC.Identity){

            PAT.Pattern patapp(PAT.Pattern pattern) {
                return pattern;
            }
        };
        static Functor Yes = new Functor(CCC.Yes){

            PAT.Pattern patapp(PAT.Pattern pattern) {
                return new PAT.Yes(pattern);
            }
        };
        static Functor No = new Functor(CCC.No){

            PAT.Pattern patapp(PAT.Pattern pattern) {
                return new PAT.No(pattern);
            }
        };

        Functor(CCC.Combinator combinator) {
            this.comb = combinator;
        }

        abstract PAT.Pattern patapp(PAT.Pattern var1);

        Functor compose(Functor functor) {
            return new Functor(this, functor, new CCC.Compose(functor.comb, this.comb)){
                private final /* synthetic */ Functor val$par;
                private final /* synthetic */ Functor this$0;
                {
                    this.this$0 = functor;
                    this.val$par = functor2;
                }

                PAT.Pattern patapp(PAT.Pattern pattern) {
                    return this.this$0.patapp(this.val$par.patapp(pattern));
                }
            };
        }

        public String toString() {
            return "X -> " + this.patapp(new PAT.Variable("X"));
        }
    }

    public static class NameOcc
    extends Structure {
        private String name;
        private Structure[] arg;

        public NameOcc(String string, Structure[] structureArray) {
            this.name = string;
            this.arg = structureArray;
        }

        void compile(Map map) throws TYP.ApplicationException {
            Object v = map.get(this.name);
            if (v instanceof TYP.Ref && this.arg.length == 0) {
                this.type = (TYP.Ref)map.get(this.name);
            } else if (v instanceof TYP.Constructor) {
                Application application = new Application((TYP.Constructor)v, this.arg);
                ((Structure)application).compile(map);
                this.type = application.type;
            }
        }

        public String toString(String string) {
            return new TYP.Constructor(this.name, this.arg.length).toStringApp(this.arg, string);
        }
    }

    public static class Sum
    extends Application {
        public Sum(Structure structure, Structure structure2) {
            super(TYP.Constructor.Sum, new Structure[]{structure, structure2});
        }

        void constructors(Map map, Functor functor, TYP.Scheme scheme) {
            this.arg[0].constructors(map, functor.compose(Functor.Yes), scheme);
            this.arg[1].constructors(map, functor.compose(Functor.No), scheme);
        }

        void selectors(Map map, CCC.Combinator combinator, TYP.Scheme scheme) {
            this.arg[0].selectors(map, new CCC.Compose(combinator, new CCC.Compose(CCC.MatchYes, CCC.Content)), scheme);
            this.arg[1].selectors(map, new CCC.Compose(combinator, new CCC.Compose(CCC.MatchNo, CCC.Content)), scheme);
        }
    }

    public static class Product
    extends Application {
        public Product(Structure structure, Structure structure2) {
            super(TYP.Constructor.Product, new Structure[]{structure, structure2});
        }

        void constructors(Map map, Functor functor, TYP.Scheme scheme) {
            this.arg[0].constructors(map, Functor.Id, scheme);
            this.arg[1].constructors(map, Functor.Id, scheme);
        }

        void selectors(Map map, CCC.Combinator combinator, TYP.Scheme scheme) {
            this.arg[0].selectors(map, new CCC.Compose(combinator, CCC.Fst), scheme);
            this.arg[1].selectors(map, new CCC.Compose(combinator, CCC.Snd), scheme);
        }
    }

    public static class Function
    extends Application {
        public Function(Structure structure, Structure structure2) {
            super(TYP.Constructor.Function, new Structure[]{structure, structure2});
        }
    }

    private static class Application
    extends Structure {
        private TYP.Constructor fun;
        protected Structure[] arg;

        public Application(TYP.Constructor constructor, Structure[] structureArray) {
            this.fun = constructor;
            this.arg = structureArray;
        }

        public Application(TYP.Constructor constructor) {
            this(constructor, new Structure[0]);
        }

        void compile(Map map) throws TYP.ApplicationException {
            TYP.Ref[] refArray = new TYP.Ref[this.arg.length];
            int n = 0;
            while (n < this.arg.length) {
                this.arg[n].compile(map);
                refArray[n] = this.arg[n].type;
                ++n;
            }
            this.type = new TYP.Ref(new TYP.Application(this.fun, refArray));
        }

        public String toString(String string) {
            return this.fun.toStringApp(this.arg, string);
        }
    }

    public static class SelectorTag
    extends Structure {
        private String tag;
        private Structure struct;

        public SelectorTag(String string, Structure structure) {
            this.tag = string;
            this.struct = structure;
        }

        void compile(Map map) throws TYP.ApplicationException {
            this.struct.compile(map);
            this.type = this.struct.type;
        }

        void constructors(Map map, Functor functor, TYP.Scheme scheme) {
            this.struct.constructors(map, functor, scheme);
        }

        void selectors(Map map, CCC.Combinator combinator, TYP.Scheme scheme) {
            if (this.tag != null) {
                map.put(this.tag, new AST.Atomic(new CCC.Abstract(new CCC.Compose(CCC.Snd, combinator), this.tag), new TYP.Scheme(scheme.universal, TYP.Function(scheme.type, this.type)).copy()));
            }
            this.struct.selectors(map, combinator, scheme);
        }

        public String toString(String string) {
            return this.tag + ">  " + this.struct.toString(string + "   ");
        }
    }

    public static class ConstructorTag
    extends Structure {
        private String tag;
        private Structure struct;
        private Constructor con;

        public ConstructorTag(String string, Structure structure) {
            this.tag = string;
            this.struct = structure;
        }

        void compile(Map map) throws TYP.ApplicationException {
            this.struct.compile(map);
            this.type = this.struct.type;
        }

        void constructors(Map map, Functor functor, TYP.Scheme scheme) {
            this.con = new Constructor(this.tag, functor, new TYP.Scheme(scheme.universal, TYP.Function(this.type, scheme.type)).copy());
            map.put(this.tag, this.con);
            this.struct.constructors(map, Functor.Id, new TYP.Scheme(scheme.universal, this.type));
        }

        void selectors(Map map, CCC.Combinator combinator, TYP.Scheme scheme) {
            this.struct.selectors(map, combinator, scheme);
        }

        public String toString(String string) {
            return this.tag + (string.startsWith("\n") ? "  : " + this.con + string : "") + "<  " + this.struct.toString(string + "   ");
        }
    }

    public static abstract class Structure
    implements UTL.Prettyprint {
        protected TYP.Ref type;

        abstract void compile(Map var1) throws TYP.ApplicationException;

        void constructors(Map map, Functor functor, TYP.Scheme scheme) {
        }

        void selectors(Map map, CCC.Combinator combinator, TYP.Scheme scheme) {
        }

        public String toString() {
            return UTL.compressWhitespace(this.toString(""));
        }

        public abstract String toString(String var1);
    }

    public static class Declaration
    extends TYP.Constructor
    implements UTL.Prettyprint {
        private String[] args;
        private Structure struct;

        public Declaration(String string, String[] stringArray, Structure structure) {
            super(string, stringArray.length);
            this.args = stringArray;
            this.struct = structure;
        }

        public void compile(Map map, Map map2) throws TYP.ApplicationException {
            TYP.Quantifier quantifier = new TYP.Quantifier();
            UTL.ShadowMap shadowMap = new UTL.ShadowMap(map2);
            TYP.Ref[] refArray = new TYP.Ref[this.args.length];
            int n = 0;
            while (n < this.args.length) {
                refArray[n] = new TYP.Ref(new TYP.Variable(this.args[n], quantifier));
                shadowMap.put(this.args[n], refArray[n]);
                ++n;
            }
            TYP.Scheme scheme = new TYP.Scheme(quantifier, new TYP.Ref(new TYP.Application(this, refArray)));
            this.struct.compile(shadowMap);
            this.struct.constructors(map, Functor.Id, scheme);
            this.struct.selectors(map, CCC.Identity, scheme);
        }

        public String toString() {
            return UTL.compressWhitespace(this.toString(""));
        }

        public String toString(String string) {
            String string2 = this.name + " ";
            int n = 0;
            while (n < this.args.length) {
                string2 = string2 + this.args[n] + " ";
                ++n;
            }
            return string2 + ":" + string + "   " + this.struct.toString(string + "   ") + " ." + string;
        }
    }
}

