/*
 * Decompiled with CFR 0.152.
 */
package com.florianhaber.camlog.ast;

import com.florianhaber.camlog.ast.PAT;
import com.florianhaber.camlog.ast.TYP;
import com.florianhaber.camlog.cam.CCC;
import com.florianhaber.camlog.cam.DOM;
import com.florianhaber.camlog.utl.UTL;

public class AST {
    public static Term Failure = new Atomic(CCC.Failure, TYP.TOP);
    public static Term Nil = new Atomic(CCC.Nil, TYP.One);

    public static Term result(Term term, Term term2) {
        Term term3;
        if (term instanceof Alter) {
            Alter alter = (Alter)term;
            return new Alter(AST.result(alter.alt1, term2), AST.result(alter.alt2, term2.copy()));
        }
        if (term instanceof Bind) {
            term3 = (Bind)term;
            if (term3.proc instanceof Abstract) {
                return new Bind(term3.act, AST.result(term3.proc, term2));
            }
        }
        if (term instanceof Abstract) {
            term3 = (Abstract)term;
            return new Abstract(((Abstract)term3).fml, AST.result(((Abstract)term3).body, term2), ((Abstract)term3).name);
        }
        if (term instanceof Let) {
            term3 = (Let)term;
            return new Let(((Let)term3).fml, ((Let)term3).act, AST.result(((Let)term3).body, term2));
        }
        if (term instanceof CallCCS) {
            return new CallCCS(AST.result(((CallCCS)term).body, term2));
        }
        if (term instanceof CallCCF) {
            return new CallCCF(AST.result(((CallCCF)term).body, term2));
        }
        return new Bind(term, new Abstract(new PAT.Variable("$dummy"), term2));
    }

    public static class MycroftException
    extends TypingException {
        public Term term;
        public TYP.Ref type;
        public TYP.Scheme assertion;

        public MycroftException(Term term, TYP.Ref ref, TYP.Scheme scheme) {
            super("maximum Mycroft iteration level (" + Fixpoint.MYCROFT + ") exceeded\n" + "   term: " + term + "\n" + "   expected type: " + ref + "\n" + "   asserted type: " + scheme);
            this.term = term;
            this.type = ref;
            this.assertion = scheme;
        }
    }

    public static class TermTypingException
    extends TypingException {
        public Term term;
        public TYP.Ref type;
        public TYP.UnificationException ue;

        public TermTypingException(Term term, TYP.Ref ref, TYP.UnificationException unificationException) {
            super("type for " + UTL.className(term) + " term cannot be infered\n" + "   term: " + term + "\n" + "   expected type: " + ref + "\n" + "" + unificationException);
            this.term = term;
            this.type = ref;
            this.ue = unificationException;
        }
    }

    public static class TypingException
    extends Exception {
        protected TypingException(String string) {
            super(string);
        }
    }

    public static class ResolutionException
    extends Exception {
        String name;

        public ResolutionException(String string) {
            super("occurrence of variable '" + string + "' cannot be resolved");
            this.name = string;
        }
    }

    public static class CallCCF
    extends Term {
        private Term body;

        public CallCCF(Term term) {
            this.body = term;
        }

        public void resolve(PAT.Pattern pattern) throws ResolutionException {
            this.body.resolve(pattern);
        }

        public void typing(TYP.Ref ref, TYP.Quantifier quantifier) throws TypingException {
            TYP.Ref ref2 = new TYP.Ref(new TYP.Variable(quantifier));
            this.body.typing(TYP.Function(TYP.Function(TYP.One, ref2), ref), quantifier);
        }

        public CCC.Combinator compile(PAT.Pattern pattern) {
            return new CCC.CallCCF(this.body.compile(pattern));
        }

        public Term copy() {
            return new CallCCF(this.body.copy());
        }

        public String toString(String string) {
            return "(call/cc-" + string + "   " + this.body.toString(string + "   ") + string + ")";
        }
    }

    public static class CallCCS
    extends Term {
        private Term body;

        public CallCCS(Term term) {
            this.body = term;
        }

        public void resolve(PAT.Pattern pattern) throws ResolutionException {
            this.body.resolve(pattern);
        }

        public void typing(TYP.Ref ref, TYP.Quantifier quantifier) throws TypingException {
            TYP.Ref ref2 = new TYP.Ref(new TYP.Variable(quantifier));
            this.body.typing(TYP.Function(TYP.Function(ref, ref2), ref), quantifier);
        }

        public CCC.Combinator compile(PAT.Pattern pattern) {
            return new CCC.CallCCS(this.body.compile(pattern));
        }

        public Term copy() {
            return new CallCCS(this.body.copy());
        }

        public String toString(String string) {
            return "(call/cc+" + string + "   " + this.body.toString(string + "   ") + string + ")";
        }
    }

    public static class Fixpoint
    extends Term {
        private PAT.Pattern fml;
        private Term rule;
        public static int MYCROFT = 16;

        public Fixpoint(PAT.Pattern pattern, Term term) {
            this.fml = pattern;
            this.rule = term;
        }

        public void resolve(PAT.Pattern pattern) throws ResolutionException {
            this.fml.resolve(pattern);
            this.rule.resolve(new PAT.Pair(pattern, this.fml));
        }

        public void typing(TYP.Ref ref, TYP.Quantifier quantifier) throws TypingException {
            TYP.Scheme scheme = new TYP.Scheme(quantifier, ref);
            TYP.Scheme scheme2 = null;
            int n = 0;
            while (n < MYCROFT) {
                scheme2 = scheme.copy();
                this.fml.asserT(scheme2);
                this.rule.typing(ref, quantifier);
                if (scheme2.equivalent(scheme)) {
                    return;
                }
                ++n;
            }
            throw new MycroftException(this, ref, scheme2);
        }

        public CCC.Combinator compile(PAT.Pattern pattern) {
            return new CCC.Fixpoint(this.rule.compile(new PAT.Pair(pattern, new PAT.Freeze(this.fml))));
        }

        public Term copy() {
            return new Fixpoint(this.fml.copy(), this.rule.copy());
        }

        public String toString(String string) {
            return "(fix" + string + "   " + this.fml.toString(string + "   ") + string + ".  " + this.rule.toString(string + "   ") + string + ")";
        }
    }

    public static class Operation
    extends Atomic {
        private CCC.Combinator comb;

        public Operation(CCC.Combinator combinator, TYP.Scheme scheme) {
            super(new CCC.Abstract(new CCC.Compose(CCC.Snd, combinator), combinator.toString()), scheme);
            this.comb = combinator;
        }

        public CCC.Combinator compileApp(PAT.Pattern pattern, CCC.Combinator combinator) {
            return new CCC.Compose(combinator, this.comb);
        }

        public Term copy() {
            return new Operation(this.comb, this.type);
        }

        public String toString(String string) {
            return this.comb.toString();
        }
    }

    public static class Literal
    extends Atomic {
        private Object value;

        public Literal(Object object, TYP.Scheme scheme) {
            super(new CCC.Quote(object), scheme);
            this.value = object;
        }

        public CCC.Combinator compileApp(PAT.Pattern pattern, CCC.Combinator combinator) {
            return new CCC.Op((DOM.Operation)this.value, combinator);
        }

        public Term copy() {
            return new Literal(this.value, this.type);
        }
    }

    public static class Atomic
    extends Term {
        private CCC.Combinator combinator;
        protected TYP.Scheme type;

        public Atomic(CCC.Combinator combinator, TYP.Scheme scheme) {
            this.combinator = combinator;
            this.type = scheme;
        }

        public void resolve(PAT.Pattern pattern) {
        }

        public void typing(TYP.Ref ref, TYP.Quantifier quantifier) throws TypingException {
            try {
                ref.unify(this.type.instantiate(quantifier));
            }
            catch (TYP.UnificationException unificationException) {
                throw new TermTypingException(this, ref, unificationException);
            }
        }

        public CCC.Combinator compile(PAT.Pattern pattern) {
            return this.combinator;
        }

        public Term copy() {
            return new Atomic(this.combinator, this.type);
        }

        public String toString(String string) {
            return this.combinator.toString();
        }
    }

    public static class VarOcc
    extends Term {
        private PAT.Variable refersto;

        public VarOcc(PAT.Variable variable) {
            this.refersto = variable;
        }

        public void resolve(PAT.Pattern pattern) {
        }

        public void typing(TYP.Ref ref, TYP.Quantifier quantifier) throws TypingException {
            this.refersto.variableTyping(quantifier, ref);
        }

        public CCC.Combinator compile(PAT.Pattern pattern) {
            return pattern.compileOcc(this.refersto);
        }

        public Term copy() {
            throw new Error("THIS CAN'T HAPPEN - trying to copy VarOcc");
        }

        public String toString(String string) {
            return this.refersto.toString();
        }
    }

    public static class NameOcc
    extends Term {
        private String name;
        private Term resolved;

        public NameOcc(String string) {
            this.name = string;
        }

        public void resolve(PAT.Pattern pattern) throws ResolutionException {
            this.resolved = pattern.resolveOcc(this.name);
            if (this.resolved == null) {
                throw new ResolutionException(this.name);
            }
        }

        public void typing(TYP.Ref ref, TYP.Quantifier quantifier) throws TypingException {
            this.resolved.typing(ref, quantifier);
        }

        public CCC.Combinator compile(PAT.Pattern pattern) {
            return this.resolved.compile(pattern);
        }

        public CCC.Combinator compileApp(PAT.Pattern pattern, CCC.Combinator combinator) {
            return this.resolved.compileApp(pattern, combinator);
        }

        public Term copy() {
            return new NameOcc(this.name);
        }

        public String toString(String string) {
            return this.name;
        }
    }

    public static class Pair
    extends Term {
        private Term fst;
        private Term snd;

        public Pair(Term term, Term term2) {
            this.fst = term;
            this.snd = term2;
        }

        public void resolve(PAT.Pattern pattern) throws ResolutionException {
            this.fst.resolve(pattern);
            this.snd.resolve(pattern);
        }

        public void typing(TYP.Ref ref, TYP.Quantifier quantifier) throws TypingException {
            TYP.Ref ref2 = new TYP.Ref(new TYP.Variable(quantifier));
            TYP.Ref ref3 = new TYP.Ref(new TYP.Variable(quantifier));
            try {
                ref.unify(TYP.Product(ref2, ref3));
            }
            catch (TYP.UnificationException unificationException) {
                throw new TermTypingException(this, ref, unificationException);
            }
            this.fst.typing(ref2, quantifier);
            this.snd.typing(ref3, quantifier);
        }

        public CCC.Combinator compile(PAT.Pattern pattern) {
            return new CCC.Pair(this.fst.compile(pattern), this.snd.compile(pattern));
        }

        public Term copy() {
            return new Pair(this.fst.copy(), this.snd.copy());
        }

        public String toString(String string) {
            return "<  " + this.fst.toString(string + "   ") + string + "|  " + this.snd.toString(string + "   ") + string + ">";
        }
    }

    public static class Let
    extends Term {
        private PAT.Pattern fml;
        public Term act;
        private Term body;
        private Term pseudoLet;

        public Let(PAT.Pattern pattern, Term term, Term term2) {
            this.fml = pattern;
            this.act = term;
            this.body = term2;
            this.pseudoLet = new Bind(term, new Abstract(pattern, term2));
        }

        public void resolve(PAT.Pattern pattern) throws ResolutionException {
            this.pseudoLet.resolve(pattern);
        }

        public void typing(TYP.Ref ref, TYP.Quantifier quantifier) throws TypingException {
            TYP.Quantifier quantifier2 = new TYP.Quantifier(quantifier);
            TYP.Ref ref2 = new TYP.Ref(new TYP.Variable(quantifier2));
            this.act.typing(ref2, quantifier2);
            this.fml.asserT(new TYP.Scheme(quantifier2, ref2).copy());
            this.body.typing(ref, quantifier);
        }

        public CCC.Combinator compile(PAT.Pattern pattern) {
            return this.pseudoLet.compile(pattern);
        }

        public Term copy() {
            return new Let(this.fml.copy(), this.act.copy(), this.body.copy());
        }

        public String toString(String string) {
            return "( let " + this.fml.toString(string + "      ") + string + "    = " + this.act.toString(string + "      ") + string + "   in " + this.body.toString(string + "      ") + string + ")";
        }
    }

    public static class Abstract
    extends Term {
        private PAT.Pattern fml;
        private Term body;
        public String name = null;

        public Abstract(PAT.Pattern pattern, Term term) {
            this.fml = pattern;
            this.body = term;
        }

        public Abstract(PAT.Pattern pattern, Term term, String string) {
            this(pattern, term);
            this.name = string;
        }

        public void resolve(PAT.Pattern pattern) throws ResolutionException {
            this.fml.resolve(pattern);
            this.body.resolve(new PAT.Pair(pattern, this.fml));
        }

        public void typing(TYP.Ref ref, TYP.Quantifier quantifier) throws TypingException {
            TYP.Ref ref2 = new TYP.Ref(new TYP.Variable(quantifier));
            TYP.Ref ref3 = new TYP.Ref(new TYP.Variable(quantifier));
            this.fml.asserT(new TYP.Scheme(new TYP.Quantifier(quantifier), ref2));
            try {
                ref.unify(TYP.Function(ref2, ref3));
            }
            catch (TYP.UnificationException unificationException) {
                throw new TermTypingException(this, ref, unificationException);
            }
            this.body.typing(ref3, quantifier);
        }

        public CCC.Combinator compile(PAT.Pattern pattern) {
            CCC.Combinator combinator = this.fml.guard();
            if (combinator == null) {
                return new CCC.Abstract(this.body.compile(new PAT.Pair(pattern, this.fml)), this.name);
            }
            return new CCC.Abstract(new CCC.Compose(new CCC.Pair(new CCC.Compose(CCC.Snd, combinator), this.body.compile(new PAT.Pair(pattern, this.fml))), CCC.Snd), this.name);
        }

        public Term copy() {
            return new Abstract(this.fml.copy(), this.body.copy(), this.name);
        }

        public String toString(String string) {
            return "(/\\" + (this.name != null ? " \"" + this.name + "\"" + string + "   " : "") + this.fml.toString(string + "   ") + string + ".  " + this.body.toString(string + "   ") + string + ")";
        }
    }

    public static class Bind
    extends Term {
        public Term act;
        public Term proc;

        public Bind(Term term, Term term2) {
            this.act = term;
            this.proc = term2;
        }

        public void resolve(PAT.Pattern pattern) throws ResolutionException {
            this.proc.resolve(pattern);
            this.act.resolve(pattern);
        }

        public void typing(TYP.Ref ref, TYP.Quantifier quantifier) throws TypingException {
            TYP.Ref ref2 = new TYP.Ref(new TYP.Variable(quantifier));
            this.act.typing(ref2, quantifier);
            this.proc.typing(TYP.Function(ref2, ref), quantifier);
        }

        public CCC.Combinator compile(PAT.Pattern pattern) {
            return this.proc.compileApp(pattern, this.act.compile(pattern));
        }

        public Term copy() {
            return new Bind(this.act.copy(), this.proc.copy());
        }

        public String toString(String string) {
            return "(  " + this.act.toString(string + "   ") + string + ",  " + this.proc.toString(string + "   ") + string + ")";
        }
    }

    public static class Alter
    extends Term {
        private Term alt1;
        private Term alt2;
        private boolean backtrack;

        public Alter(Term term, Term term2, boolean bl) {
            this.alt1 = term;
            this.alt2 = term2;
            this.backtrack = bl;
        }

        public Alter(Term term, Term term2) {
            this(term, term2, false);
        }

        public void resolve(PAT.Pattern pattern) throws ResolutionException {
            this.alt1.resolve(pattern);
            this.alt2.resolve(pattern);
        }

        public void typing(TYP.Ref ref, TYP.Quantifier quantifier) throws TypingException {
            this.alt1.typing(ref, quantifier);
            this.alt2.typing(ref, quantifier);
        }

        public CCC.Combinator compile(PAT.Pattern pattern) {
            return new CCC.Alter(this.alt1.compile(pattern), this.alt2.compile(pattern), this.backtrack);
        }

        public Term copy() {
            return new Alter(this.alt1.copy(), this.alt2.copy(), this.backtrack);
        }

        public String toString(String string) {
            return "(  " + this.alt1.toString(string + "   ") + string + ";" + (this.backtrack ? "* " : "  ") + this.alt2.toString(string + "   ") + string + ")";
        }
    }

    public static abstract class Term
    implements UTL.Prettyprint {
        public abstract void resolve(PAT.Pattern var1) throws ResolutionException;

        public abstract void typing(TYP.Ref var1, TYP.Quantifier var2) throws TypingException;

        public abstract CCC.Combinator compile(PAT.Pattern var1);

        public CCC.Combinator compileApp(PAT.Pattern pattern, CCC.Combinator combinator) {
            return new CCC.Compose(new CCC.Pair(this.compile(pattern), combinator), CCC.Apply);
        }

        public abstract Term copy();

        public String toString() {
            return UTL.compressWhitespace(this.toString(""));
        }

        public abstract String toString(String var1);
    }
}

