/*
 * Decompiled with CFR 0.152.
 */
package com.florianhaber.camlog.ast;

import com.florianhaber.camlog.ast.ALG;
import com.florianhaber.camlog.ast.AST;
import com.florianhaber.camlog.ast.TYP;
import com.florianhaber.camlog.cam.CCC;
import com.florianhaber.camlog.res.STD;
import com.florianhaber.camlog.utl.UTL;
import java.util.Map;

public class PAT {
    public static Pattern Nil = new Pattern(){

        public void asserT(TYP.Scheme scheme) throws TypeAssertionException {
            try {
                scheme.type.unify(TYP.One);
            }
            catch (TYP.UnificationException unificationException) {
                throw new TypeAssertionException(this, scheme, unificationException);
            }
        }

        public String toString(String string) {
            return "Nil";
        }
    };

    public static class VariableTypingException
    extends AST.TypingException {
        public Variable vbl;

        public VariableTypingException(Variable variable, TYP.UnificationException unificationException) {
            super("type for variable " + variable + " cannot be infered\n" + unificationException);
            this.vbl = variable;
        }
    }

    public static class TypeAssertionException
    extends AST.TypingException {
        public Pattern pat;
        public TYP.Scheme type;
        public TYP.UnificationException ue;

        public TypeAssertionException(Pattern pattern, TYP.Scheme scheme, TYP.UnificationException unificationException) {
            super("type for " + UTL.className(pattern) + " pattern cannot be infered\n" + "   term: " + pattern + "\n" + "   expected type: " + scheme + "\n" + unificationException);
            this.pat = pattern;
            this.type = scheme;
            this.ue = unificationException;
        }
    }

    public static class SymbolTable
    extends Pattern {
        private Map table;
        private Pattern pat;

        public SymbolTable(Map map, Pattern pattern) {
            this.table = map;
            this.pat = pattern;
        }

        public AST.Term resolveOcc(String string) {
            AST.Term term = (AST.Term)this.table.get(string);
            return term != null ? term : this.pat.resolveOcc(string);
        }

        public void asserT(TYP.Scheme scheme) throws TypeAssertionException {
            this.pat.asserT(scheme);
        }

        public void resolve(Pattern pattern) throws AST.ResolutionException {
            this.pat.resolve(pattern);
        }

        CCC.Combinator compileOcc(Variable variable) {
            return this.pat.compileOcc(variable);
        }

        CCC.Combinator guard() {
            return this.pat.guard();
        }

        public Pattern copy() {
            return new SymbolTable(this.table, this.pat.copy());
        }

        public String toString(String string) {
            return "(SYMBOL TABLE: " + this.table + string + "   " + this.pat.toString(string + "   ") + string + ")";
        }
    }

    public static class Constructor
    extends Pattern {
        private String name;
        private Pattern param;
        private ALG.Constructor constr;

        public Constructor(String string, Pattern pattern) {
            this.name = string;
            this.param = pattern;
        }

        public AST.Term resolveOcc(String string) {
            return this.param.resolveOcc(string);
        }

        public void asserT(TYP.Scheme scheme) throws TypeAssertionException {
            TYP.Ref ref = this.constr.type.instantiate(scheme.universal);
            TYP.Ref ref2 = new TYP.Ref(new TYP.Variable(scheme.universal));
            try {
                ref.unify(TYP.Function(ref2, scheme.type));
            }
            catch (TYP.UnificationException unificationException) {
                throw new TypeAssertionException(this, scheme, unificationException);
            }
            this.param.asserT(new TYP.Scheme(scheme.universal, ref2));
        }

        public void resolve(Pattern pattern) throws AST.ResolutionException {
            this.constr = (ALG.Constructor)pattern.resolveOcc(this.name);
            this.param.resolve(pattern);
        }

        CCC.Combinator compileOcc(Variable variable) {
            CCC.Combinator combinator = this.param.compileOcc(variable);
            if (combinator == null) {
                return null;
            }
            return new CCC.Compose(new CCC.Pair(this.constr.strip, CCC.Identity), new CCC.Compose(CCC.Apply, combinator));
        }

        CCC.Combinator guard() {
            CCC.Combinator combinator = this.param.guard();
            return new CCC.Compose(new CCC.Pair(this.constr.guard, CCC.Identity), new CCC.Compose(CCC.Apply, combinator != null ? combinator : CCC.Identity));
        }

        public Pattern copy() {
            return new Constructor(this.name, this.param.copy());
        }

        public String toString(String string) {
            return "(" + this.name + string + "   " + this.param.toString(string + "   ") + string + ")";
        }
    }

    public static class Constant
    extends Pattern {
        private AST.Literal k;
        private AST.Term eqocc = new AST.NameOcc("equal");

        public Constant(AST.Literal literal) {
            this.k = literal;
        }

        public void asserT(TYP.Scheme scheme) throws TypeAssertionException {
            try {
                scheme.type.unify(this.k.type.instantiate(TYP.Quantifier.EMPTY));
            }
            catch (TYP.UnificationException unificationException) {
                throw new TypeAssertionException(this, scheme, unificationException);
            }
        }

        public void resolve(Pattern pattern) throws AST.ResolutionException {
            this.eqocc.resolve(pattern);
        }

        CCC.Combinator guard() {
            Variable variable = new Variable("$x");
            return new AST.Bind(new AST.Pair(new AST.VarOcc(variable), this.k), this.eqocc).compile(variable);
        }

        public String toString(String string) {
            return this.k.toString();
        }
    }

    public static class Plus
    extends Pattern {
        private Pattern n;
        private String op;
        private Integer k;
        private AST.Term opocc;

        public Plus(Pattern pattern, String string, Integer n) {
            this.n = pattern;
            this.op = string;
            this.k = n;
            this.opocc = new AST.NameOcc(string);
        }

        public AST.Term resolveOcc(String string) {
            return this.n.resolveOcc(string);
        }

        public void asserT(TYP.Scheme scheme) throws TypeAssertionException {
            try {
                scheme.type.unify(STD.Int);
            }
            catch (TYP.UnificationException unificationException) {
                throw new TypeAssertionException(this, scheme, unificationException);
            }
            this.n.asserT(scheme);
        }

        public void resolve(Pattern pattern) throws AST.ResolutionException {
            this.opocc.resolve(pattern);
            this.n.resolve(pattern);
        }

        CCC.Combinator compileOcc(Variable variable) {
            CCC.Combinator combinator = this.n.compileOcc(variable);
            if (combinator != null) {
                Integer n = new Integer(-this.k.intValue());
                return new AST.Bind(new AST.Pair(new AST.VarOcc(variable), new AST.Literal(n, null)), this.opocc).compile(this.n);
            }
            return null;
        }

        public Pattern copy() {
            return new Plus(this.n.copy(), this.op, this.k);
        }

        public String toString(String string) {
            return "(  " + this.n.toString(string + "   ") + string + "`" + this.op + "`" + " " + this.k + string + ")";
        }
    }

    public static class Freeze
    extends Pattern {
        private Pattern body;

        public Freeze(Pattern pattern) {
            this.body = pattern;
        }

        public AST.Term resolveOcc(String string) {
            return this.body.resolveOcc(string);
        }

        public void asserT(TYP.Scheme scheme) throws TypeAssertionException {
            this.body.asserT(scheme);
        }

        public void resolve(Pattern pattern) throws AST.ResolutionException {
            this.body.resolve(pattern);
        }

        CCC.Combinator compileOcc(Variable variable) {
            CCC.Combinator combinator = this.body.compileOcc(variable);
            if (combinator != null) {
                return new CCC.Compose(CCC.UNFREEZE, combinator);
            }
            return null;
        }

        CCC.Combinator guard() {
            return new CCC.Compose(CCC.UNFREEZE, this.body.guard());
        }

        public Pattern copy() {
            return new Freeze(this.body.copy());
        }

        public String toString(String string) {
            return "(@ " + this.body + string + ")";
        }
    }

    public static class Pair
    extends Pattern {
        private Pattern fst;
        private Pattern snd;

        public Pair(Pattern pattern, Pattern pattern2) {
            this.fst = pattern;
            this.snd = pattern2;
        }

        public AST.Term resolveOcc(String string) {
            AST.Term term = this.snd.resolveOcc(string);
            return term != null ? term : this.fst.resolveOcc(string);
        }

        public void asserT(TYP.Scheme scheme) throws TypeAssertionException {
            TYP.Ref ref = new TYP.Ref(new TYP.Variable(scheme.universal));
            TYP.Ref ref2 = new TYP.Ref(new TYP.Variable(scheme.universal));
            try {
                scheme.type.unify(TYP.Product(ref, ref2));
            }
            catch (TYP.UnificationException unificationException) {
                throw new TypeAssertionException(this, scheme, unificationException);
            }
            this.fst.asserT(new TYP.Scheme(scheme.universal, ref));
            this.snd.asserT(new TYP.Scheme(scheme.universal, ref2));
        }

        public void resolve(Pattern pattern) throws AST.ResolutionException {
            this.fst.resolve(pattern);
            this.snd.resolve(pattern);
        }

        CCC.Combinator compileOcc(Variable variable) {
            CCC.Combinator combinator = this.snd.compileOcc(variable);
            if (combinator != null) {
                return new CCC.Compose(CCC.Snd, combinator);
            }
            CCC.Combinator combinator2 = this.fst.compileOcc(variable);
            if (combinator2 != null) {
                return new CCC.Compose(CCC.Fst, combinator2);
            }
            return null;
        }

        CCC.Combinator guard() {
            CCC.Combinator combinator = this.fst.guard();
            CCC.Combinator combinator2 = this.snd.guard();
            if (combinator == null && combinator2 == null) {
                return null;
            }
            if (combinator2 == null) {
                return new CCC.Compose(CCC.Fst, combinator);
            }
            if (combinator == null) {
                return new CCC.Compose(CCC.Snd, combinator2);
            }
            return new CCC.Pair(new CCC.Compose(CCC.Fst, combinator), new CCC.Compose(CCC.Snd, combinator2));
        }

        public Pattern copy() {
            return new Pair(this.fst.copy(), this.snd.copy());
        }

        public String toString(String string) {
            return "<  " + this.fst.toString(string + "   ") + string + "|  " + this.snd.toString(string + "   ") + string + ">";
        }
    }

    public static class No
    extends Variant {
        public No(Pattern pattern) {
            super(pattern);
        }

        public void asserT_aux(TYP.Ref ref, TYP.Ref ref2, TYP.Quantifier quantifier) throws TypeAssertionException {
            this.content.asserT(new TYP.Scheme(quantifier, ref2));
        }

        CCC.Combinator guard() {
            CCC.Combinator combinator = this.content.guard();
            if (combinator == null) {
                return CCC.MatchNo;
            }
            return new CCC.Compose(CCC.MatchNo, new CCC.Compose(CCC.Content, combinator));
        }

        public Pattern copy() {
            return new No(this.content);
        }

        public String toString(String string) {
            return "(No" + string + "   " + this.content.toString(string + "   ") + string + ")";
        }
    }

    public static class Yes
    extends Variant {
        public Yes(Pattern pattern) {
            super(pattern);
        }

        public void asserT_aux(TYP.Ref ref, TYP.Ref ref2, TYP.Quantifier quantifier) throws TypeAssertionException {
            this.content.asserT(new TYP.Scheme(quantifier, ref));
        }

        CCC.Combinator guard() {
            CCC.Combinator combinator = this.content.guard();
            if (combinator == null) {
                return CCC.MatchYes;
            }
            return new CCC.Compose(CCC.MatchYes, new CCC.Compose(CCC.Content, combinator));
        }

        public Pattern copy() {
            return new Yes(this.content);
        }

        public String toString(String string) {
            return "(Yes" + string + "   " + this.content.toString(string + "   ") + string + ")";
        }
    }

    public static abstract class Variant
    extends Pattern {
        protected Pattern content;

        public Variant(Pattern pattern) {
            this.content = pattern;
        }

        public AST.Term resolveOcc(String string) {
            return this.content.resolveOcc(string);
        }

        public void asserT(TYP.Scheme scheme) throws TypeAssertionException {
            TYP.Ref ref = new TYP.Ref(new TYP.Variable(scheme.universal));
            TYP.Ref ref2 = new TYP.Ref(new TYP.Variable(scheme.universal));
            try {
                scheme.type.unify(TYP.Sum(ref, ref2));
            }
            catch (TYP.UnificationException unificationException) {
                throw new TypeAssertionException(this, scheme, unificationException);
            }
            this.asserT_aux(ref, ref2, scheme.universal);
        }

        public abstract void asserT_aux(TYP.Ref var1, TYP.Ref var2, TYP.Quantifier var3) throws TypeAssertionException;

        public void resolve(Pattern pattern) throws AST.ResolutionException {
            this.content.resolve(pattern);
        }

        CCC.Combinator compileOcc(Variable variable) {
            CCC.Combinator combinator = this.content.compileOcc(variable);
            if (combinator != null) {
                return new CCC.Compose(CCC.Content, combinator);
            }
            return null;
        }
    }

    public static class GenericVariable
    extends Variable {
        public GenericVariable() {
            super("$X");
        }

        CCC.Combinator guard() {
            return CCC.Identity;
        }
    }

    public static class Variable
    extends Pattern {
        public String name;
        private TYP.Scheme assertion = null;

        public Variable(String string) {
            this.name = string;
        }

        public AST.Term resolveOcc(String string) {
            return this.name.equals(string) ? new AST.VarOcc(this) : null;
        }

        public void asserT(TYP.Scheme scheme) {
            this.assertion = scheme.copy();
        }

        public void variableTyping(TYP.Quantifier quantifier, TYP.Ref ref) throws VariableTypingException {
            try {
                ref.unify(this.assertion.instantiate(quantifier));
            }
            catch (TYP.UnificationException unificationException) {
                throw new VariableTypingException(this, unificationException);
            }
        }

        CCC.Combinator compileOcc(Variable variable) {
            return this.equals(variable) ? CCC.Identity : null;
        }

        public Pattern copy() {
            return new Variable(this.name);
        }

        public String toString(String string) {
            return this.name + (string.startsWith("\n") && this.assertion != null ? "  : " + this.assertion : "");
        }
    }

    public static abstract class Pattern {
        public AST.Term resolveOcc(String string) {
            return null;
        }

        public abstract void asserT(TYP.Scheme var1) throws TypeAssertionException;

        public void resolve(Pattern pattern) throws AST.ResolutionException {
        }

        CCC.Combinator compileOcc(Variable variable) {
            return null;
        }

        CCC.Combinator guard() {
            return null;
        }

        public Pattern copy() {
            return this;
        }

        public String toString() {
            return UTL.compressWhitespace(this.toString(""));
        }

        public abstract String toString(String var1);
    }
}

