/*
 * Decompiled with CFR 0.152.
 */
package com.florianhaber.camlog.cam;

import com.florianhaber.camlog.cam.CAM;
import com.florianhaber.camlog.cam.CCC;
import com.florianhaber.camlog.utl.UTL;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ASM {
    private List prog = new ArrayList();
    private CAM cam;
    private int base;
    private int location;

    public ASM(CAM cAM) {
        this.cam = cAM;
        this.location = this.base = cAM.free;
    }

    public CAM.Address assemble(CCC.Abstract abstract_) {
        Symbol symbol = abstract_.absCode(this.prog, this.cam);
        Iterator iterator = this.prog.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Label) {
                ((Label)e).sym.location = this.location;
                continue;
            }
            ++this.location;
        }
        return this.cam.new CAM.Address(symbol.location);
    }

    public void load() {
        this.cam.alloc(this.location);
        this.location = this.cam.free;
        Iterator iterator = this.prog.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CAM.Opcode) {
                this.cam.program[this.location++] = e;
                continue;
            }
            if (e instanceof Symbol) {
                this.cam.program[this.location++] = this.cam.new CAM.Address(((Symbol)e).location);
                continue;
            }
            if (e instanceof Label) continue;
            this.cam.program[this.location++] = e;
        }
        this.cam.free = this.location;
    }

    public void listing(PrintWriter printWriter) {
        printWriter.print("\n===ASM==========================");
        int n = this.base;
        String string = UTL.fillRight(n + "", 5) + "         ";
        Iterator iterator = this.prog.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Label) {
                string = UTL.fillRight(n + "", 5) + UTL.fillRight(e.toString(), 9);
                continue;
            }
            if (e instanceof CAM.Opcode) {
                printWriter.print("\n" + string + UTL.fillRight(e.toString(), 7));
                string = UTL.fillRight(++n + "", 5) + "         ";
                continue;
            }
            printWriter.print(" " + e);
            string = UTL.fillRight(++n + "", 5) + "         ";
        }
        printWriter.println("\n===ASM==========================\n");
    }

    public static class Label {
        Symbol sym;

        public Label(Symbol symbol) {
            this.sym = symbol;
        }

        public String toString() {
            return this.sym + ":";
        }
    }

    public static class Symbol {
        static int fresh = 0;
        private int no = fresh++;
        String name = "lbl_" + this.no;
        int location;

        Symbol() {
        }

        public Symbol(String string) {
            this();
            if (string != null) {
                this.name = string;
            }
        }

        public String toString() {
            return this.name;
        }
    }
}

