/*
 * Decompiled with CFR 0.152.
 */
package com.florianhaber.camlog.cam;

import com.florianhaber.camlog.cam.DOM;
import com.florianhaber.camlog.utl.UTL;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;

public class CAM
implements Serializable {
    public Object[] program = new Object[]{"F.H."};
    public Date timestamp;
    public transient PrintWriter errout;
    private transient int pc;
    public transient Object acc;
    private transient Stack stack;
    private transient AltCont alt;
    public int free = 1;
    public Opcode Fst = new Opcode(){
        {
            this.mnemonic = "Fst";
        }

        void exec() {
            CAM.this.acc = ((DOM.Pair)CAM.this.acc).fst;
        }
    };
    public Opcode Snd = new Opcode(){
        {
            this.mnemonic = "Snd";
        }

        void exec() {
            CAM.this.acc = ((DOM.Pair)CAM.this.acc).snd;
        }
    };
    public Opcode Push = new Opcode(){
        {
            this.mnemonic = "Push";
        }

        void exec() {
            CAM.this.push(CAM.this.acc);
        }
    };
    public Opcode Swap = new Opcode(){
        {
            this.mnemonic = "Swap";
        }

        void exec() {
            Object object = CAM.this.acc;
            CAM.this.acc = CAM.this.pop();
            CAM.this.push(object);
        }
    };
    public Opcode Cons = new Opcode(){
        {
            this.mnemonic = "Cons";
        }

        void exec() {
            CAM.this.acc = new DOM.Pair(CAM.this.pop(), CAM.this.acc);
        }
    };
    public Opcode Cur = new Opcode(){
        {
            this.mnemonic = "Cur";
        }

        void exec() {
            CAM.this.acc = new Closure(CAM.this.acc, (Address)CAM.this.operand());
        }
    };
    public Opcode App = new Opcode(){
        {
            this.mnemonic = "App";
        }

        void exec() throws Stop, GlobalFailure {
            ((Applicable)((DOM.Pair)CAM.this.acc).fst).call(((DOM.Pair)CAM.this.acc).snd, CAM.this);
        }
    };
    public Opcode Quote = new Opcode(){
        {
            this.mnemonic = "Quote";
        }

        void exec() {
            CAM.this.acc = CAM.this.operand();
        }
    };
    public OpcodeReturn Return = new OpcodeReturn();
    public Opcode Nil = new Opcode(){
        {
            this.mnemonic = "Nil";
        }

        void exec() {
            CAM.this.acc = DOM.Nil;
        }
    };
    public Opcode Alter = new Opcode(){
        {
            this.mnemonic = "Alter";
        }

        void exec() {
            CAM.this.pushAlt((Address)CAM.this.operand());
        }
    };
    public Opcode Commit = new Opcode(){
        {
            this.mnemonic = "Commit";
        }

        void exec() {
            ((Address)CAM.this.operand()).jump();
            CAM.this.popAlt();
        }
    };
    public Opcode Jump = new Opcode(){
        {
            this.mnemonic = "Jump";
        }

        void exec() {
            ((Address)CAM.this.operand()).jump();
        }
    };
    public OpcodeFail Fail = new OpcodeFail();
    public Opcode Yes = new Opcode(){
        {
            this.mnemonic = "Yes";
        }

        void exec() {
            CAM.this.acc = new DOM.Yes(CAM.this.acc);
        }
    };
    public Opcode No = new Opcode(){
        {
            this.mnemonic = "No";
        }

        void exec() {
            CAM.this.acc = new DOM.No(CAM.this.acc);
        }
    };
    public Opcode Content = new Opcode(){
        {
            this.mnemonic = "Content";
        }

        void exec() {
            CAM.this.acc = ((DOM.Variant)CAM.this.acc).content;
        }
    };
    public Opcode MatchYes = new Opcode(){
        {
            this.mnemonic = "MatchYes";
        }

        void exec() throws GlobalFailure {
            if (!(CAM.this.acc instanceof DOM.Yes)) {
                CAM.this.Fail.exec();
            }
        }
    };
    public Opcode MatchNo = new Opcode(){
        {
            this.mnemonic = "MatchNo";
        }

        void exec() throws GlobalFailure {
            if (!(CAM.this.acc instanceof DOM.No)) {
                CAM.this.Fail.exec();
            }
        }
    };
    public Opcode CallCCS = new Opcode(){
        {
            this.mnemonic = "CallCCS";
        }

        void exec() throws Stop {
            ((Closure)CAM.this.acc).call(new Cont(), null);
        }
    };
    public Opcode CallCCF = new Opcode(){
        {
            this.mnemonic = "CallCCF";
        }

        void exec() throws Stop {
            ((Closure)CAM.this.acc).call(CAM.this.alt, null);
        }
    };
    public Opcode New = new Opcode(){
        {
            this.mnemonic = "New";
        }

        void exec() {
            CAM.this.acc = new DOM.Ref();
        }
    };
    public Opcode Get = new Opcode(){
        {
            this.mnemonic = "Get";
        }

        void exec() {
            CAM.this.acc = ((DOM.Ref)CAM.this.acc).value;
        }
    };
    public Opcode Set = new Opcode(){
        {
            this.mnemonic = "Set";
        }

        void exec() {
            ((DOM.Ref)((CAM)CAM.this).pop()).value = CAM.this.acc;
        }
    };
    private static Jumpable Stop = new Jumpable(){

        public void jump() throws Stop {
            throw new Stop();
        }

        public String toString() {
            return "Stop";
        }
    };
    private JumpableAlt GlobalFailure = new JumpableAlt(){

        public void jump() throws GlobalFailure {
            CAM.this.acc = null;
            throw new GlobalFailure();
        }

        public String toString() {
            return "GlobalFailure";
        }
    };

    public void alloc(int n) {
        if (n > this.program.length) {
            Object[] objectArray = this.program;
            this.program = new Object[n];
            System.arraycopy(objectArray, 0, this.program, 0, this.free);
        }
        Arrays.fill(this.program, n, this.program.length, null);
        this.acc = null;
        this.stack = null;
        this.alt = null;
    }

    private Object operand() {
        return this.program[this.pc++];
    }

    private void push(Object object) {
        new Stack(object);
    }

    private Object top() {
        return this.stack.top;
    }

    private Object pop() {
        Object object = this.stack.top;
        this.stack = this.stack.bottom;
        return object;
    }

    private void pushAlt(JumpableAlt jumpableAlt) {
        new AltCont(jumpableAlt);
    }

    private void popAlt() {
        this.alt = this.alt.alt;
    }

    private void exec() {
        try {
            while (true) {
                ((Opcode)this.program[this.pc++]).exec();
            }
        }
        catch (GlobalFailure globalFailure) {
        }
        catch (Stop stop) {
            try {
                this.Return.exec();
            }
            catch (Stop stop2) {
                throw new Error("THIS CAN'T HAPPEN - double stop in CAM.exec");
            }
        }
        catch (DOM.InvokationException invokationException) {
            throw invokationException;
        }
        catch (Throwable throwable) {
            this.errout.println("\nCAMlog SHOULD NEVER GET HERE!\nJAVA RUNTIME ERROR DURING CAM EXECUTION...\n");
            throwable.printStackTrace(this.errout);
            this.dumpRAM();
            throw new Error();
        }
    }

    private void debug() {
        this.errout.println("\n===DEBUG========================");
        try {
            while (true) {
                this.errout.print(UTL.fillRight(this.pc + ": ", 6));
                int n = 0;
                while (n < (this.stack != null ? this.stack.depth : 0)) {
                    this.errout.print("| ");
                    ++n;
                }
                this.errout.print(this.program[this.pc] + " ->");
                ((Opcode)this.program[this.pc++]).exec();
                this.errout.println(" ACC=" + this.acc + "  STACK=" + this.stack + "  ALT=" + this.alt);
            }
        }
        catch (GlobalFailure globalFailure) {
        }
        catch (Stop stop) {
            try {
                this.Return.exec();
            }
            catch (Stop stop2) {
                throw new Error("THIS CAN'T HAPPEN - double stop in CAM.debug");
            }
        }
        catch (DOM.InvokationException invokationException) {
            throw invokationException;
        }
        catch (Throwable throwable) {
            this.errout.println("\nCAMlog SHOULD NEVER GET HERE!\nJAVA RUNTIME ERROR DURING CAM EXECUTION...\n");
            throwable.printStackTrace(this.errout);
            throw new Error();
        }
        this.errout.println("\n===DEBUG========================\n");
    }

    public void dumpRAM() {
        this.errout.println("\n===CAM=DUMP=====================");
        this.errout.println("REGISTERS:");
        this.errout.println("   PC = " + this.pc);
        this.errout.println("   ACC = " + this.acc);
        this.errout.println("   STACK =");
        int n = 0;
        Stack stack = this.stack;
        while (stack != null) {
            this.errout.println(n++ + ":   " + stack);
            stack = stack.bottom;
        }
        this.errout.println("   ALT =");
        int n2 = 0;
        AltCont altCont = this.alt;
        while (altCont != null) {
            this.errout.println(n2++ + ":   " + altCont);
            altCont = altCont.alt;
        }
        this.errout.println("===CAM=DUMP=====================\n");
    }

    public void dumpROM() {
        this.errout.println("\n===CAM=DUMP=====================");
        this.errout.println("PROGRAM:");
        int n = 0;
        while (n < this.program.length) {
            this.errout.println((n == this.pc ? "-> " : "   ") + UTL.fillRight(n + ":", 6) + "  " + (this.program[n] instanceof Opcode ? "" : "  ") + this.program[n]);
            ++n;
        }
        this.errout.println("===CAM=DUMP=====================");
    }

    public static class GlobalFailure
    extends Exception {
    }

    private static class Stop
    extends Exception {
        private Stop() {
        }
    }

    public class Address
    implements Jumpable,
    JumpableAlt,
    Serializable,
    DOM.Abstraction {
        int value;

        Address(int n) {
            this.value = n;
        }

        public void jump() {
            CAM.this.pc = this.value;
        }

        public DOM.Applicable closeOver(Object object) {
            return new Closure(object, this);
        }

        public String toString() {
            return "@" + this.value;
        }
    }

    private static interface JumpableAlt
    extends Serializable {
        public void jump() throws GlobalFailure;
    }

    private static interface Jumpable {
        public void jump() throws Stop;
    }

    class AltIterator
    extends AltCont {
        private Iterator alternatives;

        AltIterator(Iterator iterator) {
            super(new Address(CAM.this.pc));
            this.alternatives = iterator;
        }

        public void call(Object object, CAM cAM) throws GlobalFailure {
            if (this.alternatives.hasNext()) {
                CAM.this.acc = this.alternatives.next();
                CAM.this.stack = this.stack;
                this.pc.jump();
            } else {
                this.alt.call(null, null);
            }
        }

        public String toString() {
            return "AltIterator[" + this.pc + "]";
        }
    }

    private class AltCont
    implements Applicable {
        protected JumpableAlt pc;
        private Object acc;
        protected Stack stack;
        protected AltCont alt;

        AltCont(JumpableAlt jumpableAlt) {
            this.pc = jumpableAlt;
            this.acc = CAM.this.acc;
            this.stack = CAM.this.stack;
            this.alt = CAM.this.alt;
            CAM.this.alt = this;
        }

        public void call(Object object, CAM cAM) throws GlobalFailure {
            CAM.this.acc = this.acc;
            CAM.this.stack = this.stack;
            CAM.this.alt = this.alt;
            this.pc.jump();
        }

        public String toString() {
            return "Alt[" + this.pc + "]";
        }
    }

    private class Cont
    implements Applicable {
        private Address pc;
        private Stack stack;
        private AltCont alt;

        Cont() {
            this.pc = new Address(CAM.this.pc);
            this.stack = CAM.this.stack;
            this.alt = CAM.this.alt;
        }

        public void call(Object object, CAM cAM) {
            this.pc.jump();
            CAM.this.acc = object;
            CAM.this.stack = this.stack;
            CAM.this.alt = this.alt;
        }

        public String toString() {
            return "Cont[" + this.pc + "," + this.stack + "," + this.alt + "]";
        }
    }

    public class Closure
    extends DOM.Backtracker
    implements Applicable,
    DOM.Applicable,
    Serializable {
        private Object env;
        private Address pc;

        public Closure(Object object, Address address) {
            this.env = object;
            this.pc = address;
        }

        public void call(Object object, CAM cAM) {
            if (!CAM.this.program[CAM.this.pc].equals(CAM.this.Return)) {
                CAM.this.push(new Address(CAM.this.pc));
            }
            this.pc.jump();
            CAM.this.acc = new DOM.Pair(this.env, object);
        }

        public Object invoke(Object object) {
            CAM.this.push(new Address(CAM.this.pc));
            this.pc.jump();
            CAM.this.acc = new DOM.Pair(this.env, object);
            CAM.this.pushAlt(CAM.this.GlobalFailure);
            CAM.this.push(Stop);
            CAM.this.exec();
            return CAM.this.acc;
        }

        public Object reinvoke() {
            try {
                CAM.this.Fail.exec();
                CAM.this.exec();
            }
            catch (GlobalFailure globalFailure) {
                try {
                    CAM.this.Return.exec();
                }
                catch (Stop stop) {
                    throw new Error("THIS CAN'T HAPPEN - DOUBLE STOP / reinvoke");
                }
            }
            return CAM.this.acc;
        }

        public Object debug(Object object) {
            CAM.this.push(new Address(CAM.this.pc));
            this.pc.jump();
            CAM.this.acc = new DOM.Pair(this.env, object);
            CAM.this.pushAlt(CAM.this.GlobalFailure);
            CAM.this.push(Stop);
            CAM.this.debug();
            return CAM.this.acc;
        }

        public String toString() {
            return "Cl[" + this.pc + "]";
        }
    }

    static interface Applicable {
        public void call(Object var1, CAM var2) throws Stop, GlobalFailure;
    }

    private class OpcodeFail
    extends Opcode {
        private OpcodeFail() {
            this.mnemonic = "Fail";
        }

        void exec() throws GlobalFailure {
            CAM.this.alt.call(null, null);
        }
    }

    private class OpcodeReturn
    extends Opcode {
        private OpcodeReturn() {
            this.mnemonic = "Return";
        }

        void exec() throws Stop {
            ((Jumpable)CAM.this.pop()).jump();
        }
    }

    public class Op
    extends Opcode {
        Applicable fun;

        public Op(Applicable applicable) {
            this.fun = applicable;
        }

        void exec() throws Stop, GlobalFailure {
            this.fun.call(CAM.this.acc, CAM.this);
        }

        public String toString() {
            return this.fun.toString();
        }
    }

    abstract class Opcode
    implements Serializable {
        protected String mnemonic;

        Opcode() {
        }

        abstract void exec() throws Stop, GlobalFailure;

        public String toString() {
            return this.mnemonic;
        }
    }

    private class Stack {
        int depth = 0;
        Object top;
        Stack bottom;

        Stack(Object object) {
            this.depth = (CAM.this.stack != null ? ((CAM)CAM.this).stack.depth : 0) + (object instanceof Address ? 1 : 0);
            this.top = object;
            this.bottom = CAM.this.stack;
            CAM.this.stack = this;
        }

        public String toString() {
            return this.top.toString();
        }
    }
}

