/*
 * Decompiled with CFR 0.152.
 */
package com.florianhaber.camlog.cst;

import antlr.ANTLRException;
import com.florianhaber.camlog.ast.AST;
import com.florianhaber.camlog.ast.PAT;
import com.florianhaber.camlog.ast.TYP;
import com.florianhaber.camlog.cam.ASM;
import com.florianhaber.camlog.cam.CAM;
import com.florianhaber.camlog.cam.CCC;
import com.florianhaber.camlog.cam.DOM;
import com.florianhaber.camlog.cst.CTX;
import com.florianhaber.camlog.par.CAMlogLexer;
import com.florianhaber.camlog.par.CAMlogParser;
import com.florianhaber.camlog.res.RES;
import com.florianhaber.camlog.res.STDrun;
import com.florianhaber.camlog.utl.UTL;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPOutputStream;

public class CST
implements DOM.Applicable {
    public PAT.Pattern ctx_fml;
    public TYP.Scheme ctx_typ;
    public Object ctx_env;
    public CAM cam;
    public UTL.Options options;
    public Reader src;
    public CAMlogParser par;
    public AST.Term ast;
    public TYP.Quantifier scope = new TYP.Quantifier();
    public TYP.Scheme typ;
    public CCC.Combinator ccc;
    public DOM.Abstraction abs;
    public DOM.Applicable prog;
    public ASM asm;
    public Object arg;
    public Object result;
    public Iterator allResults;
    public static Map builtinSymbolTable = new HashMap();
    private UTL.ShadowMap globalSymbolTable = new UTL.ShadowMap(builtinSymbolTable);
    private static Map builtinTypeTable = new HashMap();
    protected Map globalTypeTable = new UTL.ShadowMap(builtinTypeTable);
    public static List resources;

    public CST(CTX cTX, UTL.Options options) {
        this.options = options;
        this.setContext(cTX);
    }

    public void setContext(CTX cTX) {
        this.ctx_fml = cTX.formal;
        this.ctx_typ = cTX.type;
        this.options = this.options;
        this.ctx_env = cTX.env;
        this.cam = cTX.cam;
        this.cam.free = cTX.free;
    }

    public void parse() throws ANTLRException {
        this.par = new CAMlogParser(new CAMlogLexer(this.src));
        this.ast = this.par.sourceUnit(this.globalTypeTable, this.options);
    }

    public void loadContext(String string) throws RES.ImportException, TYP.ApplicationException, ANTLRException, AST.ResolutionException, AST.TypingException, IOException {
        UTL.Options options = new UTL.Options(this.options.options + "-ctx= -bin=");
        this.setContext((CTX)new CST(CTX.Root, options).passes(new FileReader(string)));
    }

    public static void compileBuiltinTypes() throws TYP.ApplicationException {
        Iterator iterator = builtinTypeTable.values().iterator();
        while (iterator.hasNext()) {
            ((TYP.Constructor)iterator.next()).compile(builtinSymbolTable, builtinTypeTable);
        }
    }

    public void compileTypes() throws TYP.ApplicationException {
        Iterator iterator = this.globalTypeTable.values().iterator();
        while (iterator.hasNext()) {
            ((TYP.Constructor)iterator.next()).compile(this.globalSymbolTable, this.globalTypeTable);
        }
    }

    public void resolveSymbols() throws AST.ResolutionException {
        this.ast.resolve(new PAT.SymbolTable(this.globalSymbolTable, this.ctx_fml));
    }

    public void typing() throws AST.TypingException {
        this.typ = this.ctx_typ.copy();
        this.ast.typing(this.typ.type, this.typ.universal);
    }

    public void compile() {
        this.ccc = this.ast.compile(this.ctx_fml);
    }

    public void closeOver() {
        this.prog = this.abs.closeOver(this.ctx_env);
    }

    public void assemble() {
        this.asm = new ASM(this.cam);
        this.abs = this.asm.assemble((CCC.Abstract)this.ccc);
        this.asm.load();
    }

    public void cccBytecode(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.ccc);
        objectOutputStream.close();
    }

    public void camBytecode(ObjectOutputStream objectOutputStream) throws IOException {
        this.cam.timestamp = new Date();
        objectOutputStream.writeObject(this.cam);
        objectOutputStream.writeObject(this.prog);
        objectOutputStream.close();
    }

    public void progBytecode(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.prog);
        objectOutputStream.close();
    }

    public void cccBytecode(String string) throws IOException {
        this.cccBytecode(new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(string))));
    }

    public void camBytecode(String string) throws IOException {
        this.camBytecode(new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(string))));
    }

    public void progBytecode(String string) throws IOException {
        this.progBytecode(new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(string))));
    }

    public Object cccEval(Object object) {
        this.result = this.ccc.eval(object);
        return this.result;
    }

    public Object invoke(Object object) {
        this.result = this.prog.invoke(object);
        return this.result;
    }

    public Object reinvoke() {
        this.result = this.prog.reinvoke();
        return this.result;
    }

    public Object debug(Object object) {
        this.result = this.prog.debug(object);
        return this.result;
    }

    public Iterator tracker(Object object) {
        this.allResults = this.prog.tracker(object);
        return this.allResults;
    }

    public void dumpRAM() {
        this.cam.dumpRAM();
    }

    public Object passes(Reader reader) throws RES.ImportException, TYP.ApplicationException, ANTLRException, AST.ResolutionException, AST.TypingException, IOException {
        this.src = reader;
        this.parse();
        if (this.options.check("ctx")) {
            this.loadContext(this.options.value("ctx"));
        }
        if (this.options.check("res")) {
            CST.loadResources(UTL.split(this.options.value("res"), ':'));
        }
        CST.compileBuiltinTypes();
        if (this.options.check("det")) {
            STDrun.random$ = new Random(123456789L);
        }
        if (!(this.ast instanceof AST.Abstract)) {
            this.ast = new AST.Abstract(PAT.Nil, this.ast, "PROGRAM");
        }
        if (this.options.check("name")) {
            ((AST.Abstract)this.ast).name = this.options.value("name");
        }
        this.compileTypes();
        this.resolveSymbols();
        if (this.options.check("myc")) {
            AST.Fixpoint.MYCROFT = Integer.parseInt(this.options.value("myc"));
        }
        if (this.options.check("typ")) {
            try {
                this.typing();
            }
            catch (ProcessedException processedException) {
                // empty catch block
            }
        }
        this.compile();
        this.abs = (CCC.Abstract)this.ccc;
        this.closeOver();
        if (this.options.check("binc")) {
            this.progBytecode(this.options.value("binc"));
        }
        this.arg = DOM.tuple(UTL.split(this.options.value("arg"), ','));
        if (this.options.check("ccc")) {
            try {
                this.invoke(this.arg);
            }
            catch (ProcessedException processedException) {
                // empty catch block
            }
        }
        if (!this.options.check("cam")) {
            return this.result;
        }
        CCC.GLOBAL_BACKTRACKING_MODE = this.options.check("bktr");
        this.assemble();
        this.closeOver();
        if (this.options.check("bin")) {
            this.camBytecode(this.options.value("bin"));
        }
        try {
            block25: {
                try {
                    String string = this.options.value("run");
                    if (string.equals("on")) {
                        this.invoke(this.arg);
                    }
                    if (string.equals("dbg")) {
                        this.debug(this.arg);
                    }
                    if (!string.equals("all")) break block25;
                    this.tracker(this.arg);
                    while (this.allResults.hasNext()) {
                        this.allResults.next();
                    }
                }
                catch (ProcessedException processedException) {
                    Object var4_7 = null;
                    if (this.options.check("dmp")) {
                        this.dumpRAM();
                    }
                }
            }
            Object var4_6 = null;
            if (this.options.check("dmp")) {
                this.dumpRAM();
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (this.options.check("dmp")) {
                this.dumpRAM();
            }
            throw throwable;
        }
        return this.result;
    }

    public static void defineBuiltinSymbol(String string, AST.Term term) {
        builtinSymbolTable.put(string, term);
    }

    public static void defineBuiltinType(String string, TYP.Constructor constructor) {
        builtinTypeTable.put(string, constructor);
    }

    public void defineGlobalType(String string, TYP.Constructor constructor) {
        this.globalTypeTable.put(string, constructor);
    }

    public void listTypes(PrintWriter printWriter, String string) {
        Iterator iterator = this.globalTypeTable.values().iterator();
        while (iterator.hasNext()) {
            printWriter.print(((UTL.Prettyprint)iterator.next()).toString(string));
        }
    }

    public void listTypes(PrintWriter printWriter) {
        Iterator iterator = this.globalTypeTable.values().iterator();
        while (iterator.hasNext()) {
            printWriter.println("   " + iterator.next());
        }
    }

    public static void loadResources(String[] stringArray) throws RES.ImportException {
        int n = 0;
        while (n < stringArray.length) {
            try {
                Class<?> clazz = Class.forName(stringArray[n]);
                RES.importResource(clazz);
                resources.add(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RES.ImportException("ressource '" + stringArray[n] + "' not found\n" + classNotFoundException);
            }
            ++n;
        }
    }

    public static void listResources(PrintWriter printWriter) {
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            printWriter.println("   " + iterator.next());
        }
    }

    static {
        TYP.Quantifier quantifier = new TYP.Quantifier();
        TYP.Ref ref = new TYP.Ref(new TYP.Variable(quantifier));
        TYP.Ref ref2 = new TYP.Ref(new TYP.Variable(quantifier));
        CST.defineBuiltinSymbol("Yes", new AST.Operation(CCC.Yes, new TYP.Scheme(quantifier, TYP.Function(ref, TYP.Sum(ref, ref2)))));
        CST.defineBuiltinSymbol("No", new AST.Operation(CCC.No, new TYP.Scheme(quantifier, TYP.Function(ref2, TYP.Sum(ref, ref2)))));
        CST.defineBuiltinSymbol("Fst", new AST.Operation(CCC.Fst, new TYP.Scheme(quantifier, TYP.Function(TYP.Product(ref, ref2), ref))));
        CST.defineBuiltinSymbol("Snd", new AST.Operation(CCC.Snd, new TYP.Scheme(quantifier, TYP.Function(TYP.Product(ref, ref2), ref2))));
        CST.defineBuiltinSymbol("Nil", new AST.Atomic(CCC.Nil, TYP.One));
        CST.defineBuiltinType("1", TYP.Constructor.One);
        CST.defineBuiltinType("0", TYP.Constructor.Zero);
        resources = new ArrayList();
    }

    public static class ProcessedException
    extends RuntimeException {
        Exception exc;

        ProcessedException(Exception exception) {
            super("readily processed: " + exception);
            this.exc = exception;
        }

        ProcessedException() {
            super("readily processed exceptional state");
        }
    }
}

