header { 
    package com.florianhaber.camlog.par;

    import com.florianhaber.camlog.ast.*;
    import com.florianhaber.camlog.cst.*;
    import com.florianhaber.camlog.res.*;
    import com.florianhaber.camlog.utl.UTL;
    import java.util.*;
}

class CAMlogParser extends Parser;

    options {
        k=2;
//        defaultErrorHandler=false;
//	exportVocab = CAMlog; 
    }

//XXX handling local backtrack might be handled on other levels and threaded
//    through the recursive descent
    {   private boolean LOCAL_BACKTRACK = false;
    
	public String errors   = "";
	public void reportError(RecognitionException exc) {
		errors += "line "+exc.line+"/"+exc.column+": "
                         +exc.getMessage()+"\n   ";
	}	
	public void reportError(String s) {
		errors += s+"\n   ";
	}	
    }

//==============================================================================
// global program structure, special forms

//   src : dir* tdcl* spf
//   dir : option '..'
//   spf : fml0 | deftm | lbdtm

sourceUnit[Map typeTable,UTL.Options options] returns [AST.Term e=null]
    :   ( directive[options] )*
        ( typeDecl[typeTable] )*
        e = specialform
        EOF
    ;

specialform returns [AST.Term e=null]
    :   e = formula0
    |   e = defterm
    |   e = lambdaterm
    |   "context"
        { e = new CTX().Term; }
    ;

directive[UTL.Options options]
    :   "option"
        opt:STRING
        {   options.options += opt.getText().substring(1) +' ';
        }
    ;

//==============================================================================
// logical formulae

//   fml0 : cls0 [ ; [lblF] fml0 ]      fml1 : cls1 [ ; [lblF] fml1 ]
//        | Failure                          | Failure
//   cls0 : lit0 [ cls1 ]               cls1 : [ frm ] bdy1
//        |                                  | frm
//   lit0 : ~ lit0                           | (: fml1 ) [ cls1 ]
//        | (: fml0 )                   bdy1 : , [lblS] cls0
//        | exp                              | -> [lblS] cls0

formula0 returns [AST.Term e=null]
    {   AST.Term t; }
    :   e = clause0
        (   semi:SEMI
            ( e = labelF[e] ) ?
            t = formula0
            { e = new AST.Alter(e,t,LOCAL_BACKTRACK||semi.getText().equals(";*")); }
        ) ?
    |   "Failure"
        { e = AST.Failure; }
    ;
formula1[AST.Term down] returns [AST.Term e=null]
    {   AST.Term t; }
    :   e = clause1[new AST.NameOcc("$ACC")]
        (   semi:SEMI
            ( e = labelF[e] ) ?
            t = formula1[new AST.NameOcc("$ACC")]
            { e = new AST.Alter(e,t,LOCAL_BACKTRACK||semi.getText().equals(";*")); }
        ) ?
        { e = new AST.Bind(down,new AST.Abstract(new PAT.Variable("$ACC"),e)); }
    |   "Failure"
        { e = AST.Failure; }
    ;
labelF[AST.Term down] returns [AST.Term e=null]
    :   lbl:IDENTIFIER
        ":"
        { e = new AST.CallCCF(
                  new AST.Abstract(new PAT.Variable(lbl.getText()),down)
              );
        }
    ;
clause0 returns [AST.Term e=null]
    :   e = literal0
        (   e = clause1[e]
        ) ?
    |   { e = AST.Nil; }
    ;
clause1[AST.Term down] returns [AST.Term e=null]
    {   PAT.Pattern p = null; AST.Term t;
        boolean [] flagref = {false}; }
    :   p = formal
        (   e = body1[down,p]
        |   { e = new AST.Bind(down,new AST.Abstract(p,AST.Nil)); }
        )
    |   // { p = PAT.Nil; }
//XXX results in a more liberal typing.
//    maybe less efficient? perhaps introduce special wildcard pattern.
        { p = new PAT.Variable("$_"); }
        e = body1[down,p]
    |   "(:"
        e = formula1[down]
        ")"
        { e = new AST.CallCCF(new AST.Abstract( new PAT.Variable("$fail"),e)); }
        (   e = clause1[e]
        ) ?
    ;
body1[AST.Term down,PAT.Pattern p] returns [AST.Term e=null]
    {   AST.Term e2; }
    :   ","
        ( down = labelS[down] ) ?
        e = clause0
        { e = new AST.Bind(down,new AST.Abstract(p,e)); }
    |   "->"
        ( down = labelS[down] ) ?
        e = clause0
        { e = new AST.Alter(e,
                            new AST.Bind(AST.Nil,new AST.NameOcc("$fail")),
                            LOCAL_BACKTRACK
                           );
          e = new AST.Bind(down,new AST.Abstract(p,e));
        }
    ;
labelS[AST.Term down] returns [AST.Term e=null]
    :   lbl:IDENTIFIER
        ":"
        { e = new AST.CallCCS(
                  new AST.Abstract(new PAT.Variable(lbl.getText()),down)
              );
        }
    ;
literal0 returns [AST.Term e=null]
    :   "~"
        e = literal0
        { e = new AST.CallCCF(new AST.Abstract( new PAT.Variable("$fail"),
                 new AST.Alter(new AST.Bind(e,new AST.NameOcc("$fail")),AST.Nil,
                               LOCAL_BACKTRACK)
              ));
        }
    |   "(:"
        e = formula0
//XXX not always needed
        { e = new AST.CallCCF(new AST.Abstract( new PAT.Variable("$fail"),e)); }
        ")"
    |   e = expression
    ;

//==============================================================================
// functional expressions

//   exp : trm [act] | act
//   act : < [ tup ]
//   tup : trm +

expression returns [AST.Term e=null]
    {   AST.Term p; }
    :   e = term
        (   p = actual
            { e = new AST.Bind(p,e); }
        ) ?
    |   e = actual
    ;
actual returns [AST.Term e=null]
    :   "<"
        (   e = tuple
        |   { e = AST.Nil; }
        )
    ;
tuple returns [AST.Term a=null]
    {   AST.Term b; }
    :   a = term
        (   b = tuple
            { a = new AST.Pair(a,b); }
        ) ?
    ;

//==============================================================================
// operator priority terms

//   trm : rel ( `op` rel )*
//   rel : add [ relop rel ]
//   add : mul ( addop mul )*
//   mul : mon ( mulop mon )*
//   mon : op [ mon ]
//       | prm

term returns [AST.Term a=null]
    {   AST.Term b; String op; }
    :   a = relationalterm
        (   op = nameoperator
            b = relationalterm
            { a = new AST.Bind(new AST.Pair(a,b),new AST.NameOcc(op)); }
        ) *
    ;
relationalterm returns [AST.Term a=null]
    {   AST.Term b; }
    :   a = additiveterm
        (   op:RELATIONALOPERATOR
            b = relationalterm
            { a = new AST.Bind(new AST.Pair(a,b),new AST.NameOcc(op.getText())); }
        ) ?
    ;
additiveterm returns [AST.Term a=null]
    {   AST.Term b; }
    :   a = multiplicativeterm
        (   op:ADDITIVEOPERATOR
            b = multiplicativeterm
            { a = new AST.Bind(new AST.Pair(a,b),new AST.NameOcc(op.getText())); }
        ) *
    ;
multiplicativeterm returns [AST.Term a=null]
    {   AST.Term b; }
    :   a = unaryterm
        (   op:MULTIPLICATIVEOPERATOR
            b = unaryterm
            { a = new AST.Bind(new AST.Pair(a,b),new AST.NameOcc(op.getText())); }
        ) *
    ;
unaryterm returns [AST.Term a=null]
    {   String op; }
    :   op = operator
        (   a = unaryterm
            { a = new AST.Bind(a,new AST.NameOcc("unary_"+op)); }
        |   { a = new AST.NameOcc(op); }
        ) 
    |   a = primary
    ;
nameoperator returns [String op=null]
    :   "`"
        id:IDENTIFIER
        "`"
        { op = id.getText(); }
    ;
operator returns [String op=null]
    :   op = nameoperator
    |   op1:RELATIONALOPERATOR      { op = op1.getText(); }
    |   op2:ADDITIVEOPERATOR        { op = op2.getText(); }
    |   op3:MULTIPLICATIVEOPERATOR  { op = op3.getText(); }
    ;

//==============================================================================
// primary terms

//   prm : vbl | lit | '[' lst ']' | ( spf | op )
//   lst : trm lst
//       | '|' trm
//       |    

primary returns [AST.Term e=null]
    {   String op; }
    :   e = variableocc
    |   e = literal
    |   "["
        (   e = list
        |   e = rhsrulebody
            {   e = new AST.Bind( new AST.Abstract(PAT.Nil,e),
                                  new AST.NameOcc("Solutions") );
            }
        )
        "]"
    |   "("
        e = specialform
        ")"
    ;
list returns [AST.Term e=null]
    {   AST.Term t; }
    :   e = term
        t = list
        { e = new AST.Bind(new AST.Pair(e,t),new AST.NameOcc("cons")); }
    |   "|"
        e = expression
    |   { e = new AST.Bind(AST.Nil,new AST.NameOcc("nil")); }
    ;
variableocc returns [AST.Term e=null]
    :   id:IDENTIFIER
        { e = new AST.NameOcc(id.getText()); }
    ;
literal returns [AST.Literal e=null]
    :   i:INTEGER
        {   e = new AST.Literal( Integer.decode(i.getText()), STD.Int ); }
    |   s:STRING
        {   e = new AST.Literal( s.getText().substring(1), STD.String ); }
    ;

//==============================================================================
// definition terms

//   deftm : def { id rhs }+ fml0
//   rhs   : < pat0 > tup0 [ : fml0 ] .
//         | = fml0 .
//   lbdtm : > pat0 : fml0

defterm returns [AST.Term e=null]
    {   String id; PAT.Pattern fml=null; AST.Term a, a1; AST.Term act=null;
        boolean shadowed;
    }
    :   "def"
        (   { shadowed=LOCAL_BACKTRACK; }
            (   ast:MULTIPLICATIVEOPERATOR { ast.getText().equals("times") }?
                { LOCAL_BACKTRACK=true; }
            )?
            id = defname
            (       a = rhsrule[id]
                    (   {         LA(1)==IDENTIFIER
                               && LT(1).getText().equals(id)
                            ||    LT(1).getText().equals("(")
                               && LT(2).getText().equals(id)
                        }?
                        id = defname
                        a1 = rhsrule[id]
                        {   a = new AST.Alter(a,a1,LOCAL_BACKTRACK);
                        }
                    ) *
                    {   if( a instanceof AST.Bind )  //XXX just optimization
                            a = ((AST.Bind)a).proc;
                        else
                            a = new AST.Abstract(new PAT.Variable("$ACC"),a,id);
                    }
                |   a = rhsvalue
            )
            { LOCAL_BACKTRACK=shadowed; }
            {   if( fml==null ) {
                    fml = new PAT.Variable(id);
                    act = a;
                } else {
                    fml = new PAT.Pair(fml,new PAT.Variable(id));
                    act = new AST.Pair(act,a);
                }
            }
        ) +
        "in"
        e = formula0
        {   e = new AST.Let(fml,
                            new AST.Fixpoint(fml,act),
                            e );
        }
    ;

defname returns [String n=null]
    :   id:IDENTIFIER
        { n=id.getText(); }
    |   "("
        n = operator
        ")"
    ;

rhsvalue returns [AST.Term a=null] 
    :   "="
        a = formula0
        "."
    ;

rhsrule[String id] returns [AST.Term a=null] 
    {   PAT.Pattern f; }
    :   "<"
        f = pattuple0
        a = rhsrulebody
        "."
        { a = new AST.Bind(new AST.NameOcc("$ACC"),new AST.Abstract(f,a,id)); }
    ;

rhsrulebody returns [AST.Term a=null] 
    {   AST.Term res; }
    :   (   ">"
            (   res = tuple
            |   { res = AST.Nil; }
            )
        |   { res = null; }
        )
        (   ":"
            a = formula0
        |   { a = AST.Nil; }
        )
        {   if( res!=null) a=AST.result(a,res);
        }
    ;

lambdaterm returns [AST.Term e=null]
    {   PAT.Pattern p = null; AST.Term t; }
    :   p = formal
        ":" //XXXX this should be replaced by a ","
        e = formula0
        { e = new AST.Abstract(p,e); }
    ;

//==============================================================================
// patterns

//   frm   : > ptup0
//   pat   : con [ ppar ] | ppar | ptrm
//   ppar  : < ptup0
//   ptup0 : [ ptup ]
//   ptup  : ptrm [ptup]
//   ptrm  : pmtrm [ op ptrm ]
//   pmtrm : op pmtrm | pprm
//   pprm  : var | int | ( pat ) | '[' plst ']'
//   plst  : ptrm plst | '|' pat |

formal returns [PAT.Pattern p=null]
    :   ">"
        p = pattuple0
    ;
pattern returns [PAT.Pattern p=null]
    :   id:IDENTIFIER
        (   p = patparam
            {   if( id.getText().equals("Yes") )
                   p = new PAT.Yes(p);
                else if( id.getText().equals("No") )
                   p = new PAT.No(p);
                else
                   p = new PAT.Constructor(id.getText(),p);
            }
        |   p = pattermtail[new PAT.Variable(id.getText())]
        |   { p = new PAT.Variable(id.getText()); }
        )
    |   p = patparam
    |   p = patmonterm
    ;
patparam returns [PAT.Pattern p=null]
    :   "<"
        p = pattuple0
    ;
pattuple0 returns [PAT.Pattern p=null]
    :   (   p = pattuple
        |   { p = PAT.Nil; }
        )
    ;
pattuple returns [PAT.Pattern p=null]
    {   PAT.Pattern t; }
    :   p = patterm
        (   t = pattuple
            { p = new PAT.Pair(p,t); }
        ) ?
    ;
patterm returns [PAT.Pattern p=null]
    {   PAT.Pattern t; String op; }
    :   p = patmonterm
        ( p = pattermtail[p] ) ?
    ;
pattermtail [PAT.Pattern p0] returns [PAT.Pattern p=null]
    {   PAT.Pattern t; String op; }
    :   op = nameoperator
        t = patterm
        { p = new PAT.Constructor(op,new PAT.Pair(p0,t)); }
    |   op1:ADDITIVEOPERATOR
        i:INTEGER
        { p = new PAT.Plus( p0, op1.getText(), Integer.decode(i.getText()) ); }
    ;
patmonterm returns [PAT.Pattern p=null]
    {   String op; }
    :   op = nameoperator
        p = patmonterm
        { p = new PAT.Constructor("unary_"+op,p); }
    |   p = patprimary
    ;

patprimary returns [PAT.Pattern p=null]
    {   PAT.Pattern t; AST.Literal k;}
    :   id:IDENTIFIER
        { p = new PAT.Variable(id.getText()); }
    |   k = literal
        { p = new PAT.Constant( k ); }
    |   "("
        p = pattern
        ")"
    |   "["
        p = patlist
        "]"
    ;
patlist returns [PAT.Pattern p=null]
    {   PAT.Pattern t; }
    :   p = patterm
        t = patlist
        { p = new PAT.Constructor("cons",new PAT.Pair(p,t)); }
    |   "|"
        p = pattern
    |   { p = new PAT.Constructor("nil",PAT.Nil); }
    ;

//==============================================================================
// type expressions

// tdcls : ( type id = texp . ) *
// tcls  : tfml1 [ ; tfml ]
// tfml1 : [ id < ] tcls
// tcls  : [ tcls1 [ , tcls ] ]
// tcls1 : [ id > ] texp
// texp  : ttrm [ -> texp ]
// ttrm  : id tlit+ | tlit
// tlit  : ( tfml ) | id

typeDecl[Map typeTable]
    {   ALG.Structure e;
        List args = new ArrayList(); } 
    :   "type"
        id:IDENTIFIER
        (   ida:IDENTIFIER
            { args.add(ida.getText()); }
        ) *
        ":"
        e = typeFormula
        "."
        {   TYP.Constructor decl =
                new ALG.Declaration(id.getText(),
                                    (String[])args.toArray(new String[args.size()]),
                                    e );
            typeTable.put(id.getText(),decl);
        }
    ;
typeFormula returns [ALG.Structure e=null]
    {   ALG.Structure t; } 
    :   e = typeFormula1
        (   SEMI
            t = typeFormula
            { e = new ALG.Sum(e,t); }
        ) ?
    ;
typeFormula1 returns [ALG.Structure e=null]
    :   id:IDENTIFIER
        "<"
        e = typeClause
        { e = new ALG.ConstructorTag(id.getText(),e); }
    |   e = typeClause
    ;
typeClause returns [ALG.Structure e=null]
    {   ALG.Structure t; } 
    :   e = typeClause1
        (   ","
            t = typeClause
            { e = new ALG.Product(e,t); }
        ) ?
    |   { e = ALG.One; }
    ;
typeClause1 returns [ALG.Structure e=null]
    :   id:IDENTIFIER
        ">"
        e = typeExpression
        { e = new ALG.SelectorTag(id.getText(),e); }
    |   e = typeExpression
    ;
typeExpression returns [ALG.Structure e=null]
    {   ALG.Structure r; } 
    :   e = typeTerm
        (   "->"
            r = typeExpression
            { e = new ALG.Function(e,r); }
        ) ?
    ;
typeTerm returns [ALG.Structure e=null]
    {   String id;
        ALG.Structure a;
        List args = new ArrayList(); } 
    :   id = typeName
        (   a = typeLiteral
            { args.add(a); }
        ) +
        { e = new ALG.NameOcc(id,
                 (ALG.Structure[])args.toArray(new ALG.Structure[args.size()])); }
    |   e = typeLiteral        
    ;
typeLiteral returns [ALG.Structure e=null]
    {   String id; }
    :   "("
        e = typeFormula
        ")"
    |   id = typeName
        {   e = new ALG.NameOcc(id,new ALG.Structure[0]); }
    ;
typeName returns [String n=null]
    :   id:IDENTIFIER
        { n=id.getText(); }
    |   i:INTEGER
        { n=i.getText(); }
    ;

//==============================================================================


class CAMlogLexer extends Lexer;

options {
        k=2;
//	exportVocab = CAMlog; 
	charVocabulary = '\0' .. '\u00FF';
}

//XXX injections
// these are the roman cyphers: I V X L C D M
//ROMAN : ROMANi | ROMANv | ROMANx ;
//ROMANi     :   'I' ( 'I' ('I')? | 'V' | ROMANix )? ;
// ROMANix    :   'X' ( 'X' ('X')? )? ;
//ROMANv     :   'V' (ROMANvi)? ;
// ROMANvi    :   'I' ( 'I' ('I')? )? ;
//ROMANx     :   'X' ( 'X' ('X')? )? (ROMANxi | ROMANv )? ;
// ROMANxi    :   'I' ( 'I' ('I')? | 'V' )? ;

IDENTIFIER
    :   ( 'a'..'z'|'A'..'Z'|'_'|'$' )
        ( 'a'..'z'|'A'..'Z'|'_'|'$'|DIGIT|'\'' )*
    ;
WHITESPACE
	:	(	' '
		|	'\t'   
		|	NEWLINE
		)
	{ $setType(Token.SKIP); }
	;

COMMENT
	:
	(       "--"
		(~(	'\r'
		|	'\n'
		))*
		({LA(1) != EOF_CHAR}? NEWLINE)?
        |       "{-"
                ( options{greedy=false;}: (~('\r'|'\n') | NEWLINE)  ) *
                "-}"
        )
	{ $setType(Token.SKIP); }
	;

NEWLINE
    :   '\r' '\n'  { newline(); } // DOS
    |   '\n'       { newline(); } // UNIX
    ;

LEFTALTPAREN
    :   "(:"
    ;
LEFTPAREN
    :   '('
    ;
RIGHTPAREN
    :   ')'
    ;

COMMA
    :	','
    ;
SEMI
    :	';' ('*')?
    ;
TILDE
    :	'~'
    ;
ARROW
    :	"->"
    ;
LAMBDA
    :	'>'
    ;
APPLY
    :	'<'
    ;

COLON
    :   ':'
    ;
DOT
    :   '.'
    ;
BANG
    :   '!'
    ;
RELATIONALOPERATOR
    :   "==" { $setText("equal"); }
    |   "<=" { $setText("lessequal"); }
    |   "<<" { $setText("less"); }
    |   ">=" { $setText("greaterequal"); }
    |   ">>" { $setText("greater"); }
    |   "/=" { $setText("notequal"); }
    ;
ADDITIVEOPERATOR
    :   '+' { $setText("plus"); }
    |   '-' { $setText("minus"); }
    |   "++" { $setText("append"); }
    ;
MULTIPLICATIVEOPERATOR
    :   '*' { $setText("times"); }
    |   '/' { $setText("divide"); }
    |   "//" { $setText("reduce"); }
    |   '#' { $setText("length"); }
    ;
BACKTICK
    :   '`'
    ;
EQUALS
    :   '='
    ;
LEFTBRACKET
    :   '['
    ;
RIGHTBRACKET
    :   ']'
    ;
VERTICALBAR
    :   '|'
    ;

protected
ESC
	:	'\\'!
		(	'n' {$setText("\n");}
		|	'r' {$setText("\r");}
		|	't' {$setText("\t");}
		|	'b' {$setText("\b");}
		|	'f' {$setText("\f");}
		|	'"' {$setText("\"");}
		|	'\'' {$setText("\'");}
		|	'\\' {$setText("\\");}
                )
	;
STRING
options {
	testLiterals=false; //doesnt work, so we keep the first quote
}	:	'\'' //! 
		(	ESC
		|	~('\\'|'\'')
		)*
		'\''!
	;

protected
DIGIT
	:	'0'..'9'
	;

INTEGER
	:	(DIGIT)+
	;
